/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.autoworkstations.auto_crafting_table;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.autoworkstations.auto_crafting_table.AutoCraftingCraftingInventory;
import uk.co.cablepost.autoworkstations.auto_crafting_table.AutoCraftingTableScreenHandler;
import uk.co.cablepost.autoworkstations.util.ImplementedInventory;
import uk.co.cablepost.autoworkstations.util.TextUtil;

public class AutoCraftingTableBlockEntity
extends class_2586
implements class_3908,
ImplementedInventory {
    public class_2371<class_1799> inventory = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    public int forceCheckCanCraftTimer = 60;
    public int[] slotActuallyHasItem = new int[this.method_5439()];
    public class_8786<class_3955> craftingRecipe;
    public AutoCraftingCraftingInventory craftingInventory;
    class_2371<class_1799> craftingOutput = null;
    public static int UNSET_STATE = 0;
    public static int NO_RECIPE_STATE = 1;
    public static int NOT_ENOUGH_RESOURCES_STATE = 2;
    public static int OUTPUT_FULL_STATE = 3;
    public static int WORKING_STATE = 4;
    public static int RECIPE_LOCKED_STATE = 5;
    public int state = UNSET_STATE;
    public float ANIM_SPEED = 0.01f;
    public int BATCH_CRAFT_COUNT = 1;
    public static float ANIM_CORNER_X = 0.1f;
    public static float ANIM_CORNER_Z = 0.9f;
    public static float ANIM_SLOT_START_X = 0.3125f;
    public static float ANIM_SLOT_START_Z = 0.3125f;
    public static float ANIM_SLOT_GAP_X = 0.1875f;
    public static float ANIM_SLOT_GAP_Z = 0.1875f;
    public int nextAnimSlot = 0;
    public boolean animToCorner = true;
    public float animX = ANIM_CORNER_X;
    public float animZ = ANIM_CORNER_Z;
    public static int PATTERN_SLOT_START = 0;
    public static int PATTERN_SLOT_END = 8;
    public static int INPUT_SLOT_START = 9;
    public static int INPUT_SLOT_END = 17;
    public static int OUTPUT_SLOT_START = 18;
    public static int OUTPUT_SLOT_END = 26;
    public static UUID emptyUUID = UUID.fromString("e7459a01-125e-43c5-bd89-58950fa43e4d");
    public UUID lastPlayerUUID;
    public boolean lastRecipeUnlockedRes;
    public static int PROPERTY_DELEGATE_SIZE = 1;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            if (index == 0) {
                return Math.round(AutoCraftingTableBlockEntity.this.state);
            }
            return 0;
        }

        public void method_17391(int index, int value) {
        }

        public int method_17389() {
            return PROPERTY_DELEGATE_SIZE;
        }
    };

    public AutoCraftingTableBlockEntity(class_2591 blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
        this.lastPlayerUUID = emptyUUID;
        this.craftingInventory = new AutoCraftingCraftingInventory(3, 3);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 wrapperLookup) {
        class_1262.method_5426((class_2487)tag, this.inventory, (class_7225.class_7874)wrapperLookup);
        tag.method_10539("SlotActuallyHasItem", this.slotActuallyHasItem);
        tag.method_10556("AnimToCorner", this.animToCorner);
        tag.method_10569("NextAnimSlot", this.nextAnimSlot);
        tag.method_10569("State", this.state);
        tag.method_25927("LastPlayerUUID", this.lastPlayerUUID);
        tag.method_10556("LastRecipeUnlockedRes", this.lastRecipeUnlockedRes);
        super.method_11007(tag, wrapperLookup);
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 wrapperLookup) {
        super.method_11014(tag, wrapperLookup);
        class_1262.method_5429((class_2487)tag, this.inventory, (class_7225.class_7874)wrapperLookup);
        this.slotActuallyHasItem = tag.method_10561("SlotActuallyHasItem");
        this.animToCorner = tag.method_10577("AnimToCorner");
        this.nextAnimSlot = tag.method_10550("NextAnimSlot");
        this.state = tag.method_10550("State");
        try {
            this.lastPlayerUUID = tag.method_25926("LastPlayerUUID");
        }
        catch (Exception e) {
            this.lastPlayerUUID = emptyUUID;
        }
        this.lastRecipeUnlockedRes = tag.method_10577("LastRecipeUnlockedRes");
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public class_2561 method_5476() {
        return TextUtil.translatableText(this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        this.lastPlayerUUID = player.method_5667();
        return new AutoCraftingTableScreenHandler(syncId, inv, this, this.propertyDelegate);
    }

    public void checkInput() {
        this.updateSlotActuallyEmptyHack();
        this.updateCraftingRecipe();
        this.updateCanCraft();
        if (this.craftingOutput != null && !this.spaceInOutput(this.craftingOutput)) {
            this.state = OUTPUT_FULL_STATE;
        }
    }

    public void method_5431() {
        boolean serverSide;
        boolean bl = serverSide = this.method_11002() && !this.method_10997().method_8608();
        if (serverSide) {
            this.checkInput();
        }
        super.method_5431();
        if (serverSide) {
            ((class_3218)this.field_11863).method_14178().method_14128(this.method_11016());
        }
    }

    public void updateSlotActuallyEmptyHack() {
        for (int i = 0; i < this.method_5439(); ++i) {
            this.slotActuallyHasItem[i] = this.method_5438(i).method_7960() ? 0 : 1;
        }
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (slot < INPUT_SLOT_START || slot > INPUT_SLOT_END) {
            return false;
        }
        class_1792 item = stack.method_7909();
        int countInInput = this.countItemInInput(item);
        int maxStackSize = stack.method_7914();
        return countInInput < this.countPatternSlotsWithItem(item) * maxStackSize && (countInInput % maxStackSize == 0 || !this.method_5438(slot).method_7960());
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot >= OUTPUT_SLOT_START && slot <= OUTPUT_SLOT_END;
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, AutoCraftingTableBlockEntity blockEntity) {
        blockEntity.updateAnim();
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, AutoCraftingTableBlockEntity blockEntity) {
        if (blockEntity.updateAnim()) {
            for (int i = 1; i <= blockEntity.BATCH_CRAFT_COUNT && blockEntity.tryCraft(); ++i) {
            }
        }
        --blockEntity.forceCheckCanCraftTimer;
        if (blockEntity.forceCheckCanCraftTimer <= 0) {
            blockEntity.forceCheckCanCraftTimer = 100;
            blockEntity.checkInput();
        }
    }

    boolean updateCraftingInventory() {
        boolean changed = false;
        for (int i = 0; i < 9; ++i) {
            class_1799 beforeStack = this.craftingInventory.method_5438(i).method_7972();
            this.craftingInventory.method_5447(i, this.method_5438(i + PATTERN_SLOT_START).method_7972());
            class_1799 afterStack = this.craftingInventory.method_5438(i).method_7972();
            if (beforeStack.method_7960() == afterStack.method_7960() && class_1799.method_31577((class_1799)beforeStack, (class_1799)afterStack)) continue;
            changed = true;
        }
        return changed;
    }

    void updateCraftingRecipe() {
        if (!this.updateCraftingInventory()) {
            return;
        }
        String recipeIdBefore = "";
        if (this.craftingRecipe != null) {
            recipeIdBefore = this.craftingRecipe.comp_1932().toString();
        }
        assert (this.field_11863 != null);
        Optional optional = Objects.requireNonNull(this.field_11863.method_8503()).method_3772().method_8132(class_3956.field_17545, (class_9695)this.craftingInventory.method_59961(), this.field_11863);
        if (optional.isEmpty()) {
            this.craftingRecipe = null;
            return;
        }
        this.craftingRecipe = (class_8786)optional.get();
        if (!Objects.equals(this.craftingRecipe.comp_1932().toString(), recipeIdBefore)) {
            this.updateCraftingOutput(this.field_11863.method_30349());
        }
    }

    public boolean recipeLocked() {
        if (this.field_11863 == null) {
            return true;
        }
        if (!this.field_11863.method_8450().method_8355(class_1928.field_19407)) {
            return false;
        }
        if (this.lastPlayerUUID.equals(emptyUUID)) {
            return true;
        }
        class_3222 serverPlayerEntity = Objects.requireNonNull(this.field_11863.method_8503()).method_3760().method_14602(this.lastPlayerUUID);
        if (serverPlayerEntity != null) {
            this.lastRecipeUnlockedRes = serverPlayerEntity.method_14253().method_14878(this.craftingRecipe);
        }
        return !this.lastRecipeUnlockedRes;
    }

    public boolean haveEnoughItemsToCraft() {
        for (int i = PATTERN_SLOT_START; i <= PATTERN_SLOT_END; ++i) {
            class_1792 item;
            if (((class_1799)this.inventory.get(i)).method_7960() || this.countPatternSlotsWithItem(item = ((class_1799)this.inventory.get(i)).method_7909()) <= this.countItemInInput(item)) continue;
            return false;
        }
        return true;
    }

    public void takeMaterialsFromInput() {
        block0: for (int i = PATTERN_SLOT_START; i <= PATTERN_SLOT_END; ++i) {
            if (((class_1799)this.inventory.get(i)).method_7960()) continue;
            class_1792 requiredItem = ((class_1799)this.inventory.get(i)).method_7909();
            for (int j = INPUT_SLOT_START; j <= INPUT_SLOT_END; ++j) {
                class_1799 inputStack = this.method_5438(j);
                if (!inputStack.method_31574(requiredItem)) continue;
                inputStack.method_7934(1);
                continue block0;
            }
        }
    }

    public boolean spaceInOutput(class_2371<class_1799> toAdd2) {
        class_2371 toAdd = class_2371.method_10213((int)toAdd2.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < toAdd.size(); ++i) {
            toAdd.set(i, (Object)((class_1799)toAdd2.get(i)).method_7972());
        }
        class_2371 output = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
        for (int i = OUTPUT_SLOT_START; i <= OUTPUT_SLOT_END; ++i) {
            output.set(i - OUTPUT_SLOT_START, (Object)this.method_5438(i).method_7972());
        }
        for (class_1799 toAddItemStack : toAdd) {
            if (toAddItemStack.method_7960()) continue;
            for (int j = 0; j < output.size(); ++j) {
                class_1799 outputItemStack = (class_1799)output.get(j);
                if (!outputItemStack.method_7960() && !class_1799.method_31577((class_1799)toAddItemStack, (class_1799)outputItemStack)) continue;
                int spaceLeftInOutputSlot = toAddItemStack.method_7914();
                if (!outputItemStack.method_7960()) {
                    spaceLeftInOutputSlot = outputItemStack.method_7914() - outputItemStack.method_7947();
                }
                int canAddHere = Math.min(toAddItemStack.method_7947(), spaceLeftInOutputSlot);
                if (outputItemStack.method_7960()) {
                    output.set(j, (Object)toAddItemStack.method_7972());
                } else {
                    outputItemStack.method_7933(canAddHere);
                }
                toAddItemStack.method_7934(canAddHere);
                if (toAddItemStack.method_7960()) break;
            }
            if (toAddItemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    private void addItemToOutput(class_1799 itemStack) {
        for (int i = OUTPUT_SLOT_START; i <= OUTPUT_SLOT_END; ++i) {
            class_1799 outputItemStack = this.method_5438(i);
            if (!outputItemStack.method_7960() && !class_1799.method_31577((class_1799)itemStack, (class_1799)outputItemStack)) continue;
            int spaceLeftInOutputSlot = itemStack.method_7914();
            if (!outputItemStack.method_7960()) {
                spaceLeftInOutputSlot = outputItemStack.method_7914() - outputItemStack.method_7947();
            }
            int canAddHere = Math.min(itemStack.method_7947(), spaceLeftInOutputSlot);
            if (outputItemStack.method_7960()) {
                this.method_5447(i, itemStack.method_7972());
            } else {
                outputItemStack.method_7933(canAddHere);
            }
            itemStack.method_7934(canAddHere);
            if (itemStack.method_7960()) break;
        }
    }

    boolean addItemsToOutput(class_2371<class_1799> toAdd) {
        if (!this.spaceInOutput(toAdd)) {
            return false;
        }
        for (class_1799 itemStack : toAdd) {
            class_1799 toAddItemStack = itemStack.method_7972();
            if (toAddItemStack.method_7960()) continue;
            this.addItemToOutput(toAddItemStack);
        }
        return true;
    }

    void updateCanCraft() {
        if (this.craftingRecipe == null) {
            this.state = NO_RECIPE_STATE;
            return;
        }
        if (this.recipeLocked()) {
            this.state = RECIPE_LOCKED_STATE;
            return;
        }
        if (!this.haveEnoughItemsToCraft()) {
            this.state = NOT_ENOUGH_RESOURCES_STATE;
            return;
        }
        this.state = WORKING_STATE;
    }

    public boolean tryCraft() {
        if (this.craftingRecipe == null) {
            this.state = NO_RECIPE_STATE;
            return false;
        }
        if (this.recipeLocked()) {
            this.state = RECIPE_LOCKED_STATE;
            return false;
        }
        if (!this.haveEnoughItemsToCraft()) {
            this.state = NOT_ENOUGH_RESOURCES_STATE;
            return false;
        }
        if (!this.addItemsToOutput(this.craftingOutput)) {
            this.state = OUTPUT_FULL_STATE;
            return false;
        }
        this.takeMaterialsFromInput();
        return true;
    }

    private void updateCraftingOutput(class_5455 dynamicRegistryManager) {
        if (this.craftingRecipe == null) {
            this.craftingOutput = null;
            return;
        }
        class_9694 craftingRecipeInput = this.craftingInventory.method_59961();
        class_1799 craftingResult = ((class_3955)this.craftingRecipe.comp_1933()).method_8116((class_9695)craftingRecipeInput, (class_7225.class_7874)dynamicRegistryManager);
        class_2371 remainder = ((class_3955)this.craftingRecipe.comp_1933()).method_8111((class_9695)craftingRecipeInput);
        class_2371 toAdd = class_2371.method_10213((int)10, (Object)class_1799.field_8037);
        for (int i = 0; i < remainder.size(); ++i) {
            toAdd.set(i, (Object)((class_1799)remainder.get(i)).method_7972());
        }
        toAdd.set(9, (Object)craftingResult.method_7972());
        this.craftingOutput = toAdd;
    }

    public int countPatternSlotsWithItem(class_1792 item) {
        int total = 0;
        for (int i = PATTERN_SLOT_START; i <= PATTERN_SLOT_END; ++i) {
            class_1799 invStack = (class_1799)this.inventory.get(i);
            if (!invStack.method_31574(item)) continue;
            ++total;
        }
        return total;
    }

    public int countItemInInput(class_1792 item) {
        int total = 0;
        for (int i = INPUT_SLOT_START; i <= INPUT_SLOT_END; ++i) {
            class_1799 invStack = (class_1799)this.inventory.get(i);
            if (!invStack.method_31574(item)) continue;
            total += invStack.method_7947();
        }
        return total;
    }

    public boolean updateAnim() {
        if (Objects.equals(this.state, WORKING_STATE)) {
            if (this.updateAnim2()) {
                this.nextAnimSlot = -1;
                this.animToCorner = false;
                return true;
            }
        } else {
            this.nextAnimSlot = -1;
            this.animToCorner = false;
        }
        return false;
    }

    public boolean updateAnim2() {
        boolean serverSide;
        boolean bl = serverSide = this.method_11002() && !this.method_10997().method_8608();
        if (this.animToCorner) {
            if (this.moveAnimTowardsCords(ANIM_CORNER_X, ANIM_CORNER_Z)) {
                this.animToCorner = false;
                if (serverSide) {
                    this.field_11863.method_8396(null, this.field_11867, class_3417.field_20610, class_3419.field_15245, 0.03f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
                }
                for (int i = this.nextAnimSlot + 1; i < 9; ++i) {
                    class_1799 patternStack = this.method_5438(i + PATTERN_SLOT_START);
                    if (patternStack.method_7960()) continue;
                    this.nextAnimSlot = i;
                    this.method_5431();
                    return false;
                }
                this.nextAnimSlot = -1;
                this.method_5431();
                return true;
            }
        } else if (this.moveAnimTowardsCords(ANIM_SLOT_START_X + (float)(this.nextAnimSlot % 3) * ANIM_SLOT_GAP_X, ANIM_SLOT_START_Z + (float)Math.floor((float)this.nextAnimSlot / 3.0f) * ANIM_SLOT_GAP_Z)) {
            this.animToCorner = true;
            if (serverSide) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_15167, class_3419.field_15245, 0.12f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
            }
            this.method_5431();
        }
        return false;
    }

    public boolean moveAnimTowardsCords(float tx, float tz) {
        if (this.nextAnimSlot == -1 && !this.animToCorner) {
            return true;
        }
        boolean toRet = true;
        if (Math.abs(this.animX - tx) < this.ANIM_SPEED) {
            this.animX = tx;
        }
        if (this.animX > tx) {
            this.animX -= this.ANIM_SPEED;
        }
        if (this.animX < tx) {
            this.animX += this.ANIM_SPEED;
        }
        if (this.animX != tx) {
            toRet = false;
        }
        if (Math.abs(this.animZ - tz) < this.ANIM_SPEED) {
            this.animZ = tz;
        }
        if (this.animZ > tz) {
            this.animZ -= this.ANIM_SPEED;
        }
        if (this.animZ < tz) {
            this.animZ += this.ANIM_SPEED;
        }
        if (this.animZ != tz) {
            toRet = false;
        }
        return toRet;
    }
}

